<?php
$content = getContent('contact.content', true);
?>
<!-- Header Section Starts Here -->

<div class="header-top">
    <div class="container">
        <div class="header-top-area">
            <ul class="left-content">
                <li>
                    <i class="las la-phone"></i>
                    <a href="tel:<?php echo e(__(@$content->data_values->contact_number)); ?>">
                        <?php echo e(__(@$content->data_values->contact_number)); ?>

                    </a>
                </li>
                <li>
                    <i class="las la-envelope-open"></i>
                    <a href="mailto:<?php echo e(__(@$content->data_values->email)); ?>">
                        <?php echo e(__(@$content->data_values->email)); ?>

                    </a>
                </li>
            </ul>
            <div class="right-content d-flex flex-wrap" style="gap:10px">
                <div>
                    <select class="langSel form--control">
                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->code); ?>" <?php if(session('lang')==$item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php if(auth()->guard()->guest()): ?>
                <ul class="header-login">
                    <li><a class="sign-in" href="<?php echo e(route('user.login')); ?>"><i class="fas fa-sign-in-alt"></i><?php echo app('translator')->get('Sign In'); ?></a></li>
                    <li>/</li>
                    <li><a class="sign-up" href="<?php echo e(route('user.register')); ?>"><i class="fas fa-user-plus"></i><?php echo app('translator')->get('Sign Up'); ?></a></li>
                </ul>
                <?php endif; ?>
                <?php if(auth()->guard()->check()): ?>
                <ul class="header-login">
                    <li>
                        <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                    </li>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<div class="header-bottom">
    <div class="container">
        <div class="header-bottom-area">
            <div class="logo">
                <a href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(getImage(imagePath()['logoIcon']['path'].'/logo.png')); ?>" alt="<?php echo app('translator')->get('Logo'); ?>">
                </a>
            </div> <!-- Logo End -->
            <ul class="menu">
                <li>
                    <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                </li>
                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <li>
                    <a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                </li>
                <li>
                    <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                </li>
            </ul>
            <div class="d-flex flex-wrap algin-items-center">
                <a href="<?php echo e(route('ticket')); ?>" class="cmn--btn btn--sm"><?php echo app('translator')->get('Buy Tickets'); ?></a>
                <div class="header-trigger-wrapper d-flex d-lg-none ms-4">
                    <div class="header-trigger d-block d-lg-none">
                        <span></span>
                    </div>
                    <div class="top-bar-trigger">
                        <i class="las la-ellipsis-v"></i>
                    </div>
                </div><!-- Trigger End-->
            </div>
        </div>
    </div>
</div>

<!-- Header Section Ends Here -->

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function() {
        "use strict";
        $(".langSel").on("change", function() {
            window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
        });
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\Files\core\resources\views/templates/basic/partials/header.blade.php ENDPATH**/ ?>