<?php
$contents = getContent('banner.content',true);
$counters = App\Models\Counter::get();
?>
<!-- Banner Section Starts Here -->
<section class="banner-section" style="background: url(<?php echo e(getImage('assets/images/frontend/banner/'.$contents->data_values->background_image, "1500x88")); ?>) repeat-x bottom;">
    <div class="container">
        <div class="banner-wrapper">
            <div class="banner-content">
                <h1 class="title"><?php echo e(__($contents->data_values->heading)); ?></h1>
                <a href="<?php echo e(__(@$contents->data_values->link)); ?>" class="cmn--btn"><?php echo e(__(@$contents->data_values->link_title)); ?></a>
            </div>
            <div class="ticket-form-wrapper">
                <div class="ticket-header nav-tabs nav border-0">
                    <h4 class="title"><?php echo app('translator')->get('Choose Your Ticket'); ?></h4>
                </div>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="one-way">
                        <form action="<?php echo e(route('search')); ?>" class="ticket-form row g-3 justify-content-center m-0">
                            <div class="col-md-6">
                                <div class="form--group">
                                    <i class="las la-location-arrow"></i>
                                    <select class="form--control select2" name="pickup">
                                        <option value=""><?php echo app('translator')->get('Pickup Point'); ?></option>
                                        <?php $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($counter->id); ?>" <?php if(request()->pickup == $counter->id): ?> selected <?php endif; ?>><?php echo e(__($counter->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form--group">
                                    <i class="las la-map-marker"></i>
                                    <select name="destination" class="form--control select2">
                                        <option value=""><?php echo app('translator')->get('Dropping Point'); ?></option>
                                        <?php $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($counter->id); ?>" <?php if(request()->destination == $counter->id): ?> selected <?php endif; ?>><?php echo e(__($counter->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form--group">
                                    <i class="las la-calendar-check"></i>
                                    <input type="text" name="date_of_journey" class="form--control datepicker" placeholder="<?php echo app('translator')->get('Departure Date'); ?>" autocomplete="off">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form--group">
                                    <button><?php echo app('translator')->get('Find Tickets'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="shape">
        <img src="<?php echo e(getImage('assets/images/frontend/banner/'.$contents->data_values->animation_image, "200x69")); ?>" alt="bg">
    </div>
</section>
<!-- Banner Section Ends Here -->
<?php /**PATH C:\xampp\htdocs\Files\core\resources\views/templates/basic/partials/banner.blade.php ENDPATH**/ ?>